// priority: 49

let 物品移除调试日志 = false; // 设置为 true 来开启详细日志

function 物品移除日志(消息) {
    if (物品移除调试日志 && typeof console !== 'undefined' && console.log) {
        console.log("[物品移除调试]", 消息);
    }
}

let 全局ON阶段 = "kubejs_global_on_stage_enabled"; 
let 实验性玩法状态 = "experimentalGameplay_enabled";
let 实验性玩法锁定 = "experimentalGameplay_locked"; 
let 实验性玩法确认标记 = "expGameplay_confirmEnable_"; 

// --- 神话难度下移除物品 ---
// 用途: 定义在玩家处于 "难度_MYTHIC" 阶段时，哪些物品应该从其背包中移除。
// 结构: 对象数组，每个对象代表一个移除规则。
//   - id: (字符串, 必需) 要移除物品的ID, 例如 "minecraft:diamond_sword"。
//   - nbtString: (字符串, 可选)
//     - 如果提供, 则物品的完整NBT字符串必须与此字符串完全匹配才会被移除。
//       例如: '{Damage:0,Enchantments:[{id:"minecraft:sharpness",lvl:5s}]}'
//     - 如果为 null, 则只有当物品没有NBT时才会被移除。
//     - 如果未定义此属性, 则只要物品ID匹配就会被移除, 不检查NBT。
let 神话难度下移除物品 = [
    { id: "explorerscompass:explorerscompass" }, // 示例: 移除所有探险家指南针 (不检查NBT)
    /*/{
        id: "tacz:modern_kinetic_gun", // 示例: 移除特定NBT的枪
        nbtString: '{GunCurrentAmmoCount:8,GunFireMode:"SEMI",GunId:"tacz:timeless50",HasBulletInBarrel:1b}'
    },/*/
    // { id: "minecraft:stone", nbtString: null } // 示例: 仅当石头没有任何NBT时才移除它
];

// --- 额外物品移除表 ---
// 用途: 定义更复杂的物品移除规则，可以匹配特定NBT键值、完整NBT或特定附魔。
// 结构: 对象数组，每个对象代表一个移除规则。
//   通用属性:
//     - id: (字符串, 必需) 目标物品的ID。规则首先会基于此ID进行匹配。
//     - type: (字符串, 必需) 规则的匹配类型，可以是以下之一:
//       - "键值匹配": 基于nbtMatch对象中的键值对来匹配物品NBT。
//       - "完整NBT匹配": 基于nbtString来精确匹配物品的完整NBT。
//       - "附魔匹配": 基于enchantMatch数组来检查物品是否含有特定附魔。
//     - 执行一次: (布尔值, 可选, 默认为false) 如果为true, 此规则对每个玩家只会触发一次移除。
//                需要配合标记名使用。
//     - 标记名: (字符串, 可选) 当执行一次为true时使用, 用于在玩家的持久化数据中记录此规则已执行。
//
//   类型特定属性:
//     - 当 type 为 "键值匹配":
//       - nbtMatch: (对象, 必需) 定义要匹配的NBT键和期望的字符串值。
//                   例如: { "patchouli:book": "parcool:parcool_guide" }
//     - 当 type 为 "完整NBT匹配":
//       - nbtString: (字符串, 必需)
//         - 与神话列表中的nbtString用法相同，用于精确NBT匹配。
//         - null 表示匹配没有NBT的物品。
//     - 当 type 为 "附魔匹配":
//       - enchantMatch: (数组, 必需) 对象数组，定义要检查的附魔。
//         每个对象结构: { id: "附魔ID", 等级: (可选) 附魔等级 }
//         如果物品含有enchantMatch中定义的任何一个附魔，则匹配。
let 额外物品移除表 = [
    {
        type: "键值匹配",
        id: "patchouli:guide_book",
        nbtMatch: { "patchouli:book": "parcool:parcool_guide" },
        执行一次: true,
        标记名: "已移除跑酷指南"
    },
    {
        type: "键值匹配",
        id: "patchouli:guide_book",
        nbtMatch: { "patchouli:book": "irons_spellbooks:iss_guide_book" },
        执行一次: true,
        标记名: "已移除法术指南"
    },
    { type: "完整NBT匹配", id: "bosses_of_mass_destruction:soul_star", nbtString: null },
    { type: "完整NBT匹配", id: "aquamirae:divider", nbtString: null },
    /*{
        type: "附魔匹配",
        id: "minecraft:diamond_sword", // 规则应用于ID为钻石剑的物品
        enchantMatch: [ // 如果钻石剑含有以下任一附魔，则移除
            { id: "farmersdelight:backstabbing" }, // 背刺 (任何等级)
            { id: "minecraft:bane_of_arthropods", 等级: 5 } // 节肢杀手V
        ]
        // 执行一次: false, // 可选
        // 标记名: "removed_bad_sword_enchants" // 可选
    },
    {
        type: "附魔匹配",
        id: "minecraft:enchanted_book", // 规则应用于附魔书
        enchantMatch: [ // 如果附魔书存储了以下任一附魔，则移除
            { id: "minecraft:protection", 等级: 4 } // 保护IV
        ]
    }*/
];

// --- global.实验性玩法物品表 ---
// 用途: 定义在服务器的 "实验性玩法" 未开启时，哪些物品应该从玩家背包中移除。
// 结构: 混合数组，元素可以是:
//   - 字符串: 代表一个物品ID。如果物品ID匹配，则移除 (不检查NBT)。
//     例如: "goety:undeath_potion"
//   - 对象: 代表一个更具体的物品移除规则。
//     - id: (字符串, 必需) 物品ID。
//     - nbtString: (字符串, 可选)
//       - 与神话列表中的nbtString用法相同，用于精确NBT匹配。
//       - null 表示匹配没有NBT的物品。
//       - 如果未定义，则只匹配ID。
global.实验性玩法物品表 = [
    /*{ id: "enigmaticlegacy:mending_mixture", nbtString: null }, // 对象形式: 匹配ID且NBT为null
    {
        id: "minecraft:diamond_pickaxe", // 对象形式: 匹配ID和特定NBT
        nbtString: '{Damage:0,Enchantments:[{id:"minecraft:efficiency",lvl:5s},{id:"minecraft:unbreaking",lvl:3s}]}'
    },*/
    "aquamirae:terrible_sword", // 可怖之剑 
    "l2complements:craft/diffusion_wand", //结晶渗透法杖 
    "l2complements:enchantments/explosion_reject", // 
    "l2complements:enchantments/magic_reject",    // 
    "l2complements:enchantments/projectile_reject",// 
    "l2complements:enchantments/fire_reject",     // 
    "l2complements:enchantments/environment_reject",// 
    "l2complements:enchantments/eternal",         // 
    "l2complements:split_suppressor",             //分裂抑制 
    "minecraft:reinforced_deepslate", // 强化深板岩
    "twilightforest:uncrafting_table", // 暮色拆解台
    "cataclysm:void_scatter_arrow", // 虚空散射箭
    "irons_spellbooks:amethyst_rapier", // 刺晶剑
    "sophisticatedbackpacks:inception_upgrade", // 嵌套升级
    "ftbquests:screen_1", // 任务屏幕1
    "ftbquests:screen_3", // 字符串形式: 只匹配ID
    "ftbquests:screen_5",
    "ftbquests:screen_7",
    "alexsmobs:vine_lasso", // 藤蔓套索
    "alexsmobs:transmutation_table", // 嬗变台
    "alexsmobs:dimensional_carver", // 维度撕裂者
    "aquamirae:fin_cutter", // 切鳍剑
    "aquamirae:divider", // 分裂者
    "aquamirae:remnants_saber", // 残骨军刀
    "enigmaticlegacy:mending_mixture", // 混合修补物
    "enigmaticlegacy:avarice_scroll", // 无尽贪婪契约
    "goety:undeath_potion", //万灵药
    "goety:rupture_focus", //撕裂聚晶
    "goety:entangling_focus", //缠绕聚晶
    "refinedstorage:white_crafter_manager",
    "refinedstorage:orange_crafter_manager",
    "refinedstorage:magenta_crafter_manager",
    "refinedstorage:crafter_manager",
    "refinedstorage:yellow_crafter_manager",
    "refinedstorage:lime_crafter_manager",
    "refinedstorage:pink_crafter_manager",
    "refinedstorage:gray_crafter_manager",
    "refinedstorage:light_gray_crafter_manager",
    "refinedstorage:black_crafter_manager",
    "refinedstorage:red_crafter_manager",
    "refinedstorage:green_crafter_manager",
    "refinedstorage:brown_crafter_manager",
    "refinedstorage:blue_crafter_manager",
    "refinedstorage:purple_crafter_manager",
    "refinedstorage:cyan_crafter_manager",
    "l2hostility:abrahadabra",
    "l2hostility:abyssal_thorn",
    "l2hostility:adaptive",
    "l2hostility:ai_config_wand",
    "l2hostility:arena",
    "l2hostility:blindness",
    "l2hostility:book_of_omniscience",
    "l2hostility:book_of_reprint",
    "l2hostility:booster_potion",
    "l2hostility:bottle_of_curse",
    "l2hostility:bottle_of_sanity",
    "l2hostility:chaos_block",
    "l2hostility:chaos_ingot",
    "l2hostility:charm_of_looting_1",
    "l2hostility:charm_of_looting_2",
    "l2hostility:charm_of_looting_3",
    "l2hostility:charm_of_looting_4",
    "l2hostility:corrosion",
    "l2hostility:counter_strike",
    "l2hostility:curse_of_envy",
    "l2hostility:curse_of_gluttony",
    "l2hostility:curse_of_greed",
    "l2hostility:curse_of_lust",
    "l2hostility:curse_of_pride",
    "l2hostility:curse_of_sloth",
    "l2hostility:curse_of_wrath",
    "l2hostility:cursed",
    "l2hostility:dementor",
    "l2hostility:detector_glasses",
    "l2hostility:dispell",
    "l2hostility:divinity_cross",
    "l2hostility:divinity_light",
    "l2hostility:drain",
    "l2hostility:equipment_wand",
    "l2hostility:erosion",
    "l2hostility:eternal_witch_charge",
    "l2hostility:fiery",
    "l2hostility:flaming_thorn",
    "l2hostility:freezing",
    "l2hostility:gravity",
    "l2hostility:greed_of_nidhoggur",
    "l2hostility:grenade",
    "l2hostility:growth",
    "l2hostility:hostility_beacon",
    "l2hostility:hostility_detector",
    "l2hostility:hostility_essence",
    "l2hostility:hostility_orb",
    "l2hostility:hostility_spawner",
    "l2hostility:imagine_breaker",
    "l2hostility:infinity_glove",
    "l2hostility:invisible",
    "l2hostility:killer_aura",
    "l2hostility:levitation",
    "l2hostility:master",
    "l2hostility:miracle_block",
    "l2hostility:miracle_ingot",
    "l2hostility:miracle_powder",
    "l2hostility:moonwalk",
    "l2hostility:nausea",
    "l2hostility:oddeyes_glasses",
    "l2hostility:platinum_star",
    "l2hostility:pocket_of_restoration",
    "l2hostility:poison",
    "l2hostility:protection",
    "l2hostility:pulling",
    "l2hostility:ragnarok",
    "l2hostility:reflect",
    "l2hostility:regenerate",
    "l2hostility:repelling",
    "l2hostility:reprint",
    "l2hostility:ring_of_corrosion",
    "l2hostility:ring_of_divinity",
    "l2hostility:ring_of_healing",
    "l2hostility:ring_of_incarceration",
    "l2hostility:ring_of_life",
    "l2hostility:ring_of_ocean",
    "l2hostility:ring_of_reflection",
    "l2hostility:sealed_item",
    "l2hostility:shulker",
    "l2hostility:slowness",
    "l2hostility:soul_burner",
    "l2hostility:speedy",
    "l2hostility:split",
    "l2hostility:tank",
    "l2hostility:target_select_wand",
    "l2hostility:teleport",
    "l2hostility:trait_adder_wand",
    "l2hostility:triple_strip_cape",
    "l2hostility:undying",
    "l2hostility:weakness",
    "l2hostility:witch_charge",
    "l2hostility:witch_droplet",
    "l2hostility:witch_wand",
    "l2hostility:wither",
];

let 检查NBT是否含目标 = (物品NBT, 附魔名称, 附魔规则) => {
    if (!物品NBT || typeof 物品NBT.get !== "function") return false;
    let NBT标签 = 物品NBT.get(附魔名称);
    let 底层标签 = null;
    if (NBT标签 && typeof NBT标签.unwrap === "function") 底层标签 = NBT标签.unwrap();
    else if (NBT标签 && typeof NBT标签.raw === "function") 底层标签 = NBT标签.raw();
    else 底层标签 = NBT标签;

    if (底层标签 instanceof $列表标签) {
        for (let 索引 = 0; 索引 < 底层标签.size(); 索引++) {
            let 附魔条目对象 = 底层标签.get(索引);

            if (附魔条目对象 instanceof $复合标签) {
                let 当前附魔ID = 附魔条目对象.getString("id");
                if (当前附魔ID === 附魔规则.id) {
                    if (附魔规则.等级 === undefined || 附魔规则.等级 === null || 附魔条目对象.getShort("lvl") === 附魔规则.等级) {
                        return true;
                    }
                }
            }
        }
    }
    return false;
};

let 是目标物品_固定规则 = (物品, 玩家) => {
    if (!物品 || 物品.empty) return { 移除: false, 原因: null };

    if (玩家 && typeof 玩家.stages === "object" && typeof 玩家.stages.has === "function" && 玩家.stages.has("难度_MYTHIC")) {
        let 匹配神话移除规则 = 神话难度下移除物品.find(规则 => {
            if (物品.id === 规则.id) {
                if (规则.nbtString !== undefined) {
                    let 当前物品NBT = 物品.nbt ? 物品.nbt.toString() : null;
                    if (规则.nbtString === null && 当前物品NBT === null) return true;
                    return 当前物品NBT === 规则.nbtString;
                }
                return true;
            }
            return false;
        });
        if (匹配神话移除规则) return { 移除: true, 原因: "神话难度禁用" };
    }

    if (物品.id) {
        let 物品NBT = 物品.nbt;
        let 符合额外规则的规则 = 额外物品移除表.find(目标规则 => {
            if (物品.id === 目标规则.id) {
                if (目标规则.执行一次 && 目标规则.标记名 && 玩家 && 玩家.persistentData.getBoolean(目标规则.标记名)) {
                    return false;
                }
                switch (目标规则.type) {
                    case "键值匹配":
                        if (物品NBT && 目标规则.nbtMatch && typeof 物品NBT.contains === "function" && typeof 物品NBT.getString === "function") {
                            return Object.keys(目标规则.nbtMatch).every(键 => {
                                return 物品NBT.contains(键, 8) && 物品NBT.getString(键) === String(目标规则.nbtMatch[键]);
                            });
                        }
                        return false;
                    case "完整NBT匹配":
                        let 当前NBT字符串 = 物品NBT ? 物品NBT.toString() : null;
                        return ((目标规则.nbtString === null || 目标规则.nbtString === undefined) && 当前NBT字符串 === null) ||
                               (当前NBT字符串 === 目标规则.nbtString);
                    case "附魔匹配":
                        if (目标规则.enchantMatch && Array.isArray(目标规则.enchantMatch)) {
                            return 目标规则.enchantMatch.some(单个附魔规则 =>
                                检查NBT是否含目标(物品NBT, "Enchantments", 单个附魔规则) ||
                                检查NBT是否含目标(物品NBT, "StoredEnchantments", 单个附魔规则)
                            );
                        }
                        return false;
                }
            }
            return false;
        });

        if (符合额外规则的规则) {
            let 原因 = "符合额外规则";
            if (符合额外规则的规则.type === "附魔匹配") {
                原因 = "含禁用附魔";
            }
            return { 移除: true, 原因: 原因, 规则: 符合额外规则的规则 };
        }
    }
    return { 移除: false, 原因: null };
};

let 是实验性禁用物品 = (物品) => {
    if (!物品 || 物品.empty) return false;

    return global.实验性玩法物品表.some(规则 => {
        if (typeof 规则 === "string") {
            return 物品.id === 规则;
        } else if (typeof 规则 === "object" && 规则.id) {
            if (物品.id !== 规则.id) return false;
            if (规则.nbtString !== undefined) {
                let 当前物品NBT = 物品.nbt ? 物品.nbt.toString() : null;
                if (规则.nbtString === null && 当前物品NBT === null) return true;
                return 当前物品NBT === 规则.nbtString;
            }
            return true;
        }
        return false;
    });
};

PlayerEvents.inventoryChanged(e => {
    物品移除日志(`[事件] PlayerEvents.inventoryChanged 触发，玩家: ${e.player ? e.player.name.string : '未知'}`);
    let s = e.server;
    let p = e.player;

    if (!p || !s || !s.persistentData) {
        物品移除日志(`  -> 事件中止: 玩家、服务器或服务器持久数据无效。`);
        return;
    }

    if (p.isCreative()) {
        物品移除日志(`  -> 玩家 ${p.name.string} 处于创造模式，跳过物品移除。`);
        return;
    }

    let sDATA = s.persistentData;
    let 实验性玩法开启 = false;

    if (sDATA.contains(实验性玩法状态)) {
        实验性玩法开启 = sDATA.getBoolean(实验性玩法状态);
    }
    物品移除日志(`实验性玩法状态: ${实验性玩法开启 ? '开启' : '关闭'} (来自服务器数据键: ${实验性玩法状态})`);

    let 背包 = p.inventory;
    if (!背包) {
        物品移除日志(`-> 事件中止: 玩家背包无效。`);
        return;
    }
    let 空气物品 = Item.of("minecraft:air");
    let 已发送神话难度提示 = false;
    let 已发送实验性玩法提示 = false;

    // 仅检查主背包的36个槽位
    for (let 槽位索引 = 0; 槽位索引 < 36; 槽位索引++) {
        let 当前物品 = 背包.getStackInSlot(槽位索引);
        if (当前物品.empty) continue;

        物品移除日志(`检查槽位 [${槽位索引}]: ${当前物品.id}`);

        let 移除原因 = null;
        let 符合规则的规则对象 = null;

        let 固定规则检查结果 = 是目标物品_固定规则(当前物品, p);
        if (固定规则检查结果.移除) {
            移除原因 = 固定规则检查结果.原因;
            符合规则的规则对象 = 固定规则检查结果.规则;
            物品移除日志(`-> 符合固定规则，原因: ${移除原因}`);
        }

        if (!移除原因 && !实验性玩法开启) {
            物品移除日志(`实验性玩法关闭，检查是否为实验性禁用物品...`);
            if (是实验性禁用物品(当前物品)) {
                移除原因 = "实验性玩法已关闭";
                物品移除日志(`-> 是实验性禁用物品，原因: ${移除原因}`);
            } else {
                物品移除日志(`-> 不是实验性禁用物品`);
            }
        }

        if (移除原因) {
            let 被移除的物品实例 = 当前物品.copy();
            背包.setStackInSlot(槽位索引, 空气物品);
            物品移除日志(`>>>> 物品 ${被移除的物品实例.id} (NBT: ${被移除的物品实例.nbt ? 被移除的物品实例.nbt.toString() : '无'}) 已从槽位 ${槽位索引} 移除，原因: "${移除原因}"`);

            if (移除原因 === "神话难度禁用" && !已发送神话难度提示) {
                p.tell(Text.of("§c注意: 神话难度下某些物品已被禁用, 如探险家指南针。请查看服务器规则了解详情。"));
                已发送神话难度提示 = true;
                物品移除日志(`已发送神话难度提示`);
            } else if (移除原因 === "符合额外规则" && 符合规则的规则对象) {
                let 规则 = 符合规则的规则对象;
                if (规则.执行一次 && 规则.标记名 && p.persistentData && typeof p.persistentData.getBoolean === 'function' && typeof p.persistentData.putBoolean === 'function') {
                    物品移除日志(`规则类型 "${规则.type}" 是一次性的，检查标记 "${规则.标记名}"`);
                    let 当前物品NBT = 被移除的物品实例.nbt;
                    let 是否此规则导致 = false;
                    if (被移除的物品实例.id === 规则.id) {
                         switch (规则.type) {
                            case "键值匹配":
                                if (当前物品NBT && 规则.nbtMatch && typeof 当前物品NBT.contains === "function" && typeof 当前物品NBT.getString === "function") {
                                    是否此规则导致 = Object.keys(规则.nbtMatch).every(键 => {
                                        return 当前物品NBT.contains(键, 8) && 当前物品NBT.getString(键) === String(规则.nbtMatch[键]);
                                    });
                                }
                                break;
                            case "完整NBT匹配":
                                let 物品当前NBT字符串 = 当前物品NBT ? 当前物品NBT.toString() : null;
                                是否此规则导致 = ((规则.nbtString === null || 规则.nbtString === undefined) && 物品当前NBT字符串 === null) ||
                                               (物品当前NBT字符串 === 规则.nbtString);
                                break;
                            case "附魔匹配":
                                if (规则.enchantMatch && Array.isArray(规则.enchantMatch)) {
                                    是否此规则导致 = 规则.enchantMatch.some(单个附魔规则 =>
                                        检查NBT是否含目标(当前物品NBT, "Enchantments", 单个附魔规则) ||
                                        检查NBT是否含目标(当前物品NBT, "StoredEnchantments", 单个附魔规则)
                                    );
                                }
                                break;
                        }
                    }
                    物品移除日志(`确认是否此规则 (${规则.type}) 导致: ${是否此规则导致}`);
                    if (是否此规则导致 && !p.persistentData.getBoolean(规则.标记名)) {
                        p.persistentData.putBoolean(规则.标记名, true);
                        物品移除日志(`玩家 ${p.name.string} 的标记 "${规则.标记名}" 已设置为 true`);
                    } else if (是否此规则导致) {
                        物品移除日志(`标记 "${规则.标记名}" 已存在，不重复设置`);
                    }
                }
            } else if ((移除原因 === "含禁用附魔" || (移除原因 === "符合额外规则" && 符合规则的规则对象 && 符合规则的规则对象.type === "附魔匹配"))) {
                // 可以为特定类型的移除发送不同消息，如果需要的话
                // p.tell(Text.of("§e提示: 含有禁用附魔的物品已被移除。").color("yellow"));
                // 目前由 "符合额外规则" 的执行一次逻辑处理，如果需要单独提示，可以在这里加
            } else if (移除原因 === "实验性玩法已关闭" && !已发送实验性玩法提示) {
                p.tell(Text.of("§c提示: 实验性玩法未开启, 实验性物品已被移除!").color("yellow"));
                已发送实验性玩法提示 = true;
                物品移除日志(`已发送实验性玩法提示`);
            }
        }
    }
    物品移除日志(`[事件] PlayerEvents.inventoryChanged 处理完毕 for 玩家: ${p.name.string}`);
});

PlayerEvents.loggedIn(e => {
    let p = e.player;
    let s = e.server;
    if (!p || !s || p.isFake()) {
        return;
    }

    let sDATA = s.persistentData;
    if (sDATA.contains(全局ON阶段) && sDATA.getBoolean(全局ON阶段)) {
        if (!p.stages.has("ON")) {
            p.stages.add("ON");
            p.tell(Text.of("§a实验性玩法已激活，[ON] 游戏阶段已为你添加。").gold());
        }
    } else {
        if (p.stages.has("ON")) {
            p.stages.remove("ON");
            p.tell(Text.of("§c实验性玩法已关闭，[ON] 游戏阶段已为你移除。").red());
        }
    }
});

ServerEvents.commandRegistry(e => {
    let { commands: 命令, arguments: 参数 } = e;
    e.register(
        命令.literal("实验性玩法")
            .then(命令.literal("状态")
                .executes(上下文 => {
                    let 发送源 = 上下文.source;
                    let s = 发送源.server;
                    let sDATA = s.persistentData;
                    
                    let 当前玩法是否开启 = sDATA.getBoolean(全局ON阶段);
                    let 玩法键已设置 = sDATA.contains(全局ON阶段);
                    let 当前是否锁定 = sDATA.getBoolean(实验性玩法锁定);

                    let 状态文本 = Text.of("实验性玩法 ([ON]阶段) 当前状态: ");
                    if (!玩法键已设置) {
                        状态文本 = 状态文本.append(Text.of("【尚未配置, 默认为关闭】").color("yellow"));
                    } else if (当前玩法是否开启) {
                        状态文本 = 状态文本.append(Text.of("【已开启】").color("green").append(Text.of(" (特定物品移除被禁用, [ON]阶段已激活)").gray()));
                    } else {
                        状态文本 = 状态文本.append(Text.of("【已关闭】").color("red").append(Text.of(" (特定物品移除被启用, [ON]阶段未激活)").gray()));
                    }

                    if (当前是否锁定) {
                        状态文本 = 状态文本.append(Text.of(" (状态已由管理员锁定)").color("gold"));
                    }

                    if (发送源.player) 发送源.player.tell(状态文本); else 发送源.sendMessage(状态文本);
                    return 1;
                })
            )
            .then(命令.literal("开启")
                .executes(上下文 => {
                    let 发送源 = 上下文.source;
                    let s = 发送源.server;
                    let sDATA = s.persistentData;
                    let p = 发送源.player;
                    let 玩家确认标记键 = p ? 实验性玩法确认标记 + p.uuid.toString() : null;
                    let 当前是否已锁定_sdata = sDATA.getBoolean(实验性玩法锁定);

                    if (当前是否已锁定_sdata && !发送源.hasPermission(2)) {
                        let 当前玩法是否开启_sdata = sDATA.getBoolean(全局ON阶段);
                        let 锁定后的状态文本 = 当前玩法是否开启_sdata ? "开启" : "关闭";
                        let 消息 = Text.of(`§c实验性玩法当前已被管理员锁定为【${锁定后的状态文本}】, 你无法修改。`);
                        if (p) p.tell(消息); else 发送源.sendMessage(消息);
                        return 0;
                    }

                    if (p && (!p.persistentData.contains(玩家确认标记键) || !p.persistentData.getBoolean(玩家确认标记键))) {
                        p.tell(Text.of("§c§l警告! 开启实验性玩法意味着你接受潜在的不稳定性、极度不平衡的数值, 甚至存档损坏的风险! 同时将激活 [ON] 游戏阶段。").red());
                        p.tell(Text.of("§c作者不会对因开启实验性玩法而导致的任何问题负责。").red());
                        p.tell(Text.of("§e如果确认要开启, 请再次输入相同的指令: §6/实验性玩法 开启").yellow());
                        p.persistentData.putBoolean(玩家确认标记键, true);
                        return 1;
                    }

                    if (p) p.persistentData.remove(玩家确认标记键);
                    sDATA.putBoolean(全局ON阶段, true);
                    sDATA.putBoolean(实验性玩法状态, true);

                    s.players.forEach(在线玩家 => {
                        if (!在线玩家.stages.has("ON")) {
                            在线玩家.stages.add("ON");
                            在线玩家.tell(Text.of("§a已开启实验性玩法，[ON] 游戏阶段已为你激活。").gold());
                        }
                    });
                    
                    if (发送源.hasPermission(2) && 当前是否已锁定_sdata) {
                        sDATA.putBoolean(实验性玩法锁定, false);
                        let 提示 = Text.of("§e提示: 作为管理员, 你的设置已覆盖并自动解锁了实验性玩法状态。");
                        if (p) p.tell(提示); else 发送源.sendMessage(提示);
                    }

                    let 反馈消息 = "§a实验性玩法已设置为【开启】。所有在线玩家已获得 [ON] 阶段。特定物品移除将被禁用。";
                    if (p) p.tell(Text.of(反馈消息)); else 发送源.sendMessage(Text.of(反馈消息));
                    let 操作者 = p ? p.displayName.string : 发送源.name;
                    s.tell(Text.of(`[实验性玩法] ${操作者} 已将实验性玩法设置为【开启】 ([ON]阶段同步)。`));
                    return 1;
                })
            )
            .then(命令.literal("关闭")
                .executes(上下文 => {
                    let 发送源 = 上下文.source;
                    let s = 发送源.server;
                    let sDATA = s.persistentData;
                    let p = 发送源.player;
                    let 当前是否已锁定_sdata = sDATA.getBoolean(实验性玩法锁定);

                    if (当前是否已锁定_sdata && !发送源.hasPermission(2)) {
                        let 当前玩法是否开启_sdata = sDATA.getBoolean(全局ON阶段);
                        let 锁定后的状态文本 = 当前玩法是否开启_sdata ? "开启" : "关闭";
                        let 消息 = Text.of(`§c实验性玩法当前已被管理员锁定为【${锁定后的状态文本}】, 你无法修改。`);
                        if (p) p.tell(消息); else 发送源.sendMessage(消息);
                        return 0;
                    }

                    sDATA.putBoolean(全局ON阶段, false);
                    sDATA.putBoolean(实验性玩法状态, false);

                    s.players.forEach(在线玩家 => {
                        if (在线玩家.stages.has("ON")) {
                            在线玩家.stages.remove("ON");
                            在线玩家.tell(Text.of("§c已关闭实验性玩法，[ON] 游戏阶段已为你移除。").red());
                        }
                    });

                    if (发送源.hasPermission(2) && 当前是否已锁定_sdata) {
                        sDATA.putBoolean(实验性玩法锁定, false);
                        let 提示 = Text.of("§e提示: 作为管理员, 你的设置已覆盖并自动解锁了实验性玩法状态。");
                        if (p) p.tell(提示); else 发送源.sendMessage(提示);
                    }
                    
                    let 反馈消息 = "§c实验性玩法已设置为【关闭】。所有在线玩家的 [ON] 阶段已被移除。特定物品移除将被启用。";
                    if (p) p.tell(Text.of(反馈消息)); else 发送源.sendMessage(Text.of(反馈消息));
                    let 操作者 = p ? p.displayName.string : 发送源.name;
                    s.tell(Text.of(`[实验性玩法] ${操作者} 已将实验性玩法设置为【关闭】 ([ON]阶段同步)。`));
                    return 1;
                })
            )
            .then(命令.literal("锁定")
                .requires(source => source.hasPermission(2))
                .executes(上下文 => {
                    let 发送源 = 上下文.source;
                    let s = 发送源.server;
                    let sDATA = s.persistentData;
                    let p = 发送源.player;
                    let 当前玩法是否开启_sdata = sDATA.getBoolean(全局ON阶段);

                    sDATA.putBoolean(实验性玩法锁定, true);
                    let 消息 = Text.of(`§e实验性玩法当前状态为【${当前玩法是否开启_sdata ? "开启" : "关闭"}】并已【锁定】。`);
                    if (p) p.tell(消息); else 发送源.sendMessage(消息);
                    let 操作者 = p ? p.displayName.string : 发送源.name;
                    s.tell(Text.of(`[实验性玩法] 管理员 ${操作者} 已【锁定】实验性玩法状态。`));
                    return 1;
                })
            )
            .then(命令.literal("解锁")
                .requires(source => source.hasPermission(2))
                .executes(上下文 => {
                    let 发送源 = 上下文.source;
                    let s = 发送源.server;
                    let sDATA = s.persistentData;
                    let p = 发送源.player;
                    
                    if (!sDATA.getBoolean(实验性玩法锁定)) {
                        let 消息 = Text.of("§e实验性玩法当前未锁定。");
                        if (p) p.tell(消息); else 发送源.sendMessage(消息);
                        return 1;
                    }

                    sDATA.putBoolean(实验性玩法锁定, false);
                    let 消息 = Text.of("§a实验性玩法已【解锁】。现在可以设置为开启或关闭。");
                    if (p) p.tell(消息); else 发送源.sendMessage(消息);
                    let 操作者 = p ? p.displayName.string : 发送源.name;
                    s.tell(Text.of(`[实验性玩法] 管理员 ${操作者} 已【解锁】实验性玩法状态。`));
                    return 1;
                })
            )
    );
});

PlayerEvents.tick(e => {
    let p = e.player;
    let s = e.server;
    
    if (!p || !s || !s.persistentData) {
        return;
    }

    if (p.level.time % 1200 == 0) { 
        let 键是否存在 = s.persistentData.contains(实验性玩法状态);

        if (!键是否存在) { 
            p.tell(Text.of("§6[实验性玩法] §e实验性玩法状态尚未配置!").yellow());
            p.tell(Text.of("§e请使用中文指令 §b/实验性玩法 开启 或 §b/实验性玩法 关闭 来进行设置。").yellow());
            p.tell(Text.of("§e开启实验性玩法可能导致游戏不稳定或数值不平衡,设置开启或关闭后本提示将消失。").gold());
        }
    }
});